<?php

namespace App\Providers\Filament;

use App\Filament\Pages\Dashboard;
use App\Filament\Pages\Settings\ManageAdminSettings;
use App\Filament\Pages\Settings\ManageAISettings;
use App\Filament\Pages\Settings\ManageCodeAndAdsSettings;
use App\Filament\Pages\Settings\ManageColorsSettings;
use App\Filament\Pages\Settings\ManageComplianceSettings;
use App\Filament\Pages\Settings\ManageEmailsSettings;
use App\Filament\Pages\Settings\ManageFeedSettings;
use App\Filament\Pages\Settings\ManageGeneralSettings;
use App\Filament\Pages\Settings\ManageLicenseSettings;
use App\Filament\Pages\Settings\ManageMediaSettings;
use App\Filament\Pages\Settings\ManagePaymentsSettings;
use App\Filament\Pages\Settings\ManageProfilesSettings;
use App\Filament\Pages\Settings\ManageReferralSettings;
use App\Filament\Pages\Settings\ManageSecuritySettings;
use App\Filament\Pages\Settings\ManageSocialSettings;
use App\Filament\Pages\Settings\ManageStorageSettings;
use App\Filament\Pages\Settings\ManageStreamsSettings;
use App\Filament\Pages\Settings\ManageWebsocketsSettings;
use App\Filament\Plugins\CustomHeaderLabelPlugin;
use App\Filament\Resources\Attachments\AttachmentResource;
use App\Filament\Resources\ContactMessages\ContactMessageResource;
use App\Filament\Resources\Countries\CountryResource;
use App\Filament\Resources\FeaturedUsers\FeaturedUserResource;
use App\Filament\Resources\GlobalAnnouncements\GlobalAnnouncementResource;
use App\Filament\Resources\Invoices\InvoiceResource;
use App\Filament\Resources\Notifications\NotificationResource;
use App\Filament\Resources\PaymentRequests\PaymentRequestResource;
use App\Filament\Resources\Polls\PollResource;
use App\Filament\Resources\PostComments\PostCommentResource;
use App\Filament\Resources\Posts\PostResource;
use App\Filament\Resources\PublicPages\PublicPageResource;
use App\Filament\Resources\Reactions\ReactionResource;
use App\Filament\Resources\Rewards\RewardResource;
use App\Filament\Resources\Roles\Roles\RoleResource;
use App\Filament\Resources\StreamMessages\StreamMessageResource;
use App\Filament\Resources\Streams\StreamResource;
use App\Filament\Resources\Subscriptions\SubscriptionResource;
use App\Filament\Resources\Taxes\TaxResource;
use App\Filament\Resources\Transactions\TransactionResource;
use App\Filament\Resources\UserBookmarks\UserBookmarkResource;
use App\Filament\Resources\UserListMemberResource;
use App\Filament\Resources\UserLists\UserListResource;
use App\Filament\Resources\UserMessages\UserMessageResource;
use App\Filament\Resources\UserReports\UserReportResource;
use App\Filament\Resources\Users\UserResource;
use App\Filament\Resources\UserTaxes\UserTaxResource;
use App\Filament\Resources\UserVerifies\UserVerifyResource;
use App\Filament\Resources\Wallets\WalletResource;
use App\Filament\Resources\Withdrawals\WithdrawalResource;
use App\Providers\AdminHelperProvider;
use App\Providers\InstallerServiceProvider;
use App\Providers\SettingsServiceProvider;
use BezhanSalleh\FilamentShield\FilamentShieldPlugin;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\NavigationBuilder;
use Filament\Navigation\NavigationGroup;
use Filament\Navigation\NavigationItem;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Saade\FilamentLaravelLog\FilamentLaravelLogPlugin;
use App\Http\Middleware\LocaleSetter;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {

        // If the site is not installed, provision a fake admin
        // TODO: Review if really necessary
        if (!InstallerServiceProvider::checkIfInstalled()) {
            return Panel::make('admin')->id('admin');
        }

        // Local storage public url re-init, panel registration is done too early
        SettingsServiceProvider::setupLocalStorage();

        $panel = $panel
            ->default()
            ->id('admin')
            ->path('admin')
            ->colors([
                'primary' => Color::Pink,
            ])
            ->authGuard('web')
            ->brandName(getSetting('admin.title') ? getSetting('admin.title') : '')
            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            ->pages([
                Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->favicon(getSetting('site.favicon'))
            ->brandLogo(fn () => view('filament.partials.logo'))
            ->darkModeBrandLogo(fn () => view('filament.partials.logo-dark'))
            ->brandLogoHeight('2.5rem')
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
                LocaleSetter::class,
            ])
            ->plugins([
                FilamentShieldPlugin::make(),
                FilamentLaravelLogPlugin::make()
                    ->authorize(fn () => auth()->user()->can('page_ViewLog')),
                new CustomHeaderLabelPlugin(),
            ])
            ->globalSearch(false)
            ->spa();

        $this->panelNavigation($panel);

        return $panel;

    }

    public function panelNavigation($panel) {

        $panel
            ->navigation(function (NavigationBuilder $builder): NavigationBuilder {
                return $builder
                    // 1. Top-level items (outside any group)
                    ->items([
                        NavigationItem::make(__('admin.navigation.dashboard'))
                            ->icon('heroicon-o-home')
                            ->isActiveWhen(fn () => request()->routeIs('filament.admin.pages.dashboard'))
                            ->url(fn () => Dashboard::getUrl()),
                    ])

                    // 2. Grouped navigation
                    ->groups([
                        NavigationGroup::make()
                            ->icon('heroicon-o-users') // top-level category icon
                            ->label(__('admin.navigation.groups.users'))
                            ->items(
                                collect([
                                ...AdminHelperProvider::resourceNavIfCan(UserResource::class),
                                ...collect(AdminHelperProvider::resourceNavIfCan(RoleResource::class))
                                    ->map(fn ($item) => $item->badge(null))
                                    ->all(),
                                ...AdminHelperProvider::resourceNavIfCan(UserVerifyResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(WalletResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(NotificationResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(UserMessageResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(UserListResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(UserBookmarkResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(UserReportResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(FeaturedUserResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(UserTaxResource::class),
                            ])
                                // Striping any icons ; Required for filament shield v4 atm
                                ->map(fn (NavigationItem $item) => $item->icon(null)->activeIcon(null))
                                ->all()
                            ),

                        NavigationGroup::make()
                            ->label(__('admin.navigation.groups.posts'))
                            ->icon('heroicon-o-rectangle-stack')
                            ->items([
                                ...AdminHelperProvider::resourceNavIfCan(PostResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(PostCommentResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(AttachmentResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(PollResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(ReactionResource::class),
                            ])->collapsed(),

                        NavigationGroup::make()
                            ->label(__('admin.navigation.groups.finances'))
                            ->icon('heroicon-o-banknotes')
                            ->items([
                                ...AdminHelperProvider::resourceNavIfCan(TransactionResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(SubscriptionResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(WithdrawalResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(PaymentRequestResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(RewardResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(InvoiceResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(TaxResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(CountryResource::class),
                            ])->collapsed(),

                        NavigationGroup::make()
                            ->label(__('admin.navigation.groups.streams'))
                            ->icon('heroicon-o-video-camera')
                            ->items([
                                ...AdminHelperProvider::resourceNavIfCan(StreamResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(StreamMessageResource::class),
                            ])->collapsed(),

                        NavigationGroup::make()
                            ->label(__('admin.navigation.groups.site'))
                            ->icon('heroicon-o-document')
                            ->items([
                                ...AdminHelperProvider::resourceNavIfCan(PublicPageResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(ContactMessageResource::class),
                                ...AdminHelperProvider::resourceNavIfCan(GlobalAnnouncementResource::class),
                            ])->collapsed(),

                        NavigationGroup::make()
                            ->label(__('admin.navigation.groups.settings'))
                            ->icon('heroicon-o-cog-6-tooth')
                            ->items(array_filter([
                                AdminHelperProvider::settingsNavItem(__('admin.settings.general'), '', ManageGeneralSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.profiles'), '', ManageProfilesSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.feed'), '', ManageFeedSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.media'), '', ManageMediaSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.storage'), '', ManageStorageSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.payments'), '', ManagePaymentsSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.websockets'), '', ManageWebsocketsSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.emails'), '', ManageEmailsSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.social'), '', ManageSocialSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.code_and_ads'), '', ManageCodeAndAdsSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.streams'), '', ManageStreamsSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.compliance'), '', ManageComplianceSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.security'), '', ManageSecuritySettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.referrals'), '', ManageReferralSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.ai'), '', ManageAISettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.admin'), '', ManageAdminSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.theme'), '', ManageColorsSettings::class),
                                AdminHelperProvider::settingsNavItem(__('admin.settings.license'), '', ManageLicenseSettings::class),
                            ]))
                            ->collapsed(),
                    ]);
            });
        return $panel;
    }
}
